import logging


class CrawlerNodeLogger:

    def __init__(self, message_queue, log_error_node_callback):
        self.message_queue = message_queue
        self.logger = self.create_logger()
        self.log_error_node_callback = log_error_node_callback

    def create_logger(self):
        logger = logging.getLogger('scraper')                       # create logger
        logger.setLevel(logging.DEBUG)
        fh = logging.FileHandler('tmp/scraper.log')                # create console handler and set level to debug
        fh.setLevel(logging.DEBUG)
        formatter = '%(asctime)s - %(levelname)s - %(message)s'
        formatter = logging.Formatter(formatter)                    # create formatter
        fh.setFormatter(formatter)                                  # add formatter to ch
        logger.addHandler(fh)                                       # add ch to logger
        return logger

    def error(self, message):
        self.logger.error(message)
        self.log_error_node_callback()
