"""
TODO: Write a doc
"""
from core.firefox import FirefoxClient
from core.tree import Node
from core.utils import CustomWebDriverWait


class Processor:

    ALIASES = []

    def __init__(self):
        self.context = None

        self.client: FirefoxClient = None
        self.current_node: Node = None
        self.timeout = 60

    def __call__(self, context):
        self.context = context
        self.current_node = context.current_node
        self.client = self.context.client

        for alias in self.ALIASES:
            if alias.condition(self.current_node):
                self.__class__ = alias.class_()
                break

        self.process()

    def process(self):
        pass

    def wait(self, method, caption):
        CustomWebDriverWait(self.client, self.timeout).until(method, name=caption)

    def is_debug(self):
        return self.context.settings.debug


class ProcessorAlias:

    def __init__(self, condition, class_):
        self.condition = condition
        self.class_ = class_
