import os


class InputFile:

    def __init__(self, code, path):
        self.code = code
        self.path = path
        self.file = open(self.path, 'r')
        self.lines = None

    def readlines(self):
        if not self.lines:
            self.lines = self.file.readlines()
        return self.lines


class OutputFile:

    def __init__(self, code, filename, format_function):
        self.code = code
        self.filename = filename
        self.format_function = format_function
        self.path = os.path.join("output/", filename)

        self.export_file = None
        self.create_file()

    def create_file(self):
        self.export_file = open(self.path, "a+", encoding='utf-8-sig')

    def readlines(self):
        file = open(self.path, "r")
        lines = file.readlines()
        file.close()
        return lines

    def writeline(self, line):
        self.export_file.write(line)
        self.export_file.write("\n")

    def close(self):
        self.export_file.close()

    def force_close(self):
        self.export_file.close()


class CSVOutputFile(OutputFile):

    def __init__(self, column_names, *args, **kwargs):
        self.column_names = column_names
        super().__init__(*args, **kwargs)

    def create_file(self):
        super().create_file()
        if os.stat(self.path).st_size == 0:
            self.export_file.write(",".join(self.column_names))
            self.export_file.write("\n")


class JSONOutputFile(OutputFile):

    def create_file(self):
        super().create_file()
        if os.stat(self.path).st_size == 0:
            self.export_file.write("[\n")

    def close(self):
        self.export_file.write("{}")
        self.export_file.write("]")
        super().close()
